<!-- BEGIN PAGE HEADER-->
<div class="row">
    <div class="col-sm-12">
        <!-- BEGIN PAGE TITLE & BREADCRUMB-->
        <h3 class="page-title">
            Stats
        </h3>
        <!-- END PAGE TITLE & BREADCRUMB-->
    </div>
</div>
<!-- END PAGE HEADER-->

<!-- BEGIN PAGE CONTENT-->
<div class="row">
    <div class="col-sm-12">

        <div class="pull-right" style="margin-bottom: 5px">
            <span class="text-muted">Sort By:</span> 
            <div class="btn-group">
				<span class="btn btn-default"><?php echo $this->Paginator->sort('Link.created', 'Date'); ?></span>
                <span class="btn btn-default"><?php echo $this->Paginator->sort('Link.title', 'Title'); ?></span>
                <span class="btn btn-default"><?php echo $this->Paginator->sort('Link.clicks', 'Clicks'); ?></span>
            </div>
        </div>

        <div class="clearfix"></div>

        <?php foreach ($stats as $stat) : ?>
            <div class="box box-solid">
                <div class="box-body">
                    <?php
                    $short_link = $this->Html->url('/'.$stat['Link']['alias'], true);

                    $stat_title = $stat['Link']['title'];
                    if (!$stat_title) {
                        $stat_title = $short_link;
                    }
                    ?>


                    <h4><?php echo $this->Html->link($stat_title, array('controller' => 'stats', 'action' => 'view', $stat['Link']['id'])); ?></h4>
                    <p class="text-muted">
                        <small>
                            <i class="fa fa-calendar"></i> <?php echo $this->Time->niceShort($stat['Link']['created']); ?> - 
                            <i class="fa fa-hand-o-up"></i> <?php echo $stat['Link']['clicks']; ?> clicks.
                        </small>
                    </p>

                    <div class="row">
                        <div class="col-sm-6">
                            <input type="text" class="form-control input-sm" value = "<?php echo $short_link; ?>" readonly>
                        </div>
                        <div class="col-sm-6">
                            <div class="text-right">
                                <button type="button" class="btn btn-info btn-sm copy-clipboard" data-clipboard-text="<?php echo $short_link; ?>"><i class="fa fa-clipboard"></i> Copy</button>
                                <?php echo $this->Html->link('<i class="fa fa-arrow-circle-right"></i> View Stats', array('controller' => 'stats', 'action' => 'view', $stat['Link']['id']), array('escape' => false, 'class' => 'btn btn-success btn-sm')); ?>
                                <!-- AddThis Button BEGIN -->
                                <a class="addthis_button btn btn-info btn-sm" addthis:url="<?php echo urlencode($short_link); ?>" addthis:title="<?php echo h($stat['Link']['title']); ?>" addthis:description="<?php echo h($stat['Link']['description']); ?>" href="http://www.addthis.com/bookmark.php?v=300&amp;pubid=ra-5335bfca1c256beb"><i class="fa fa-share-square-o"></i> Share</a>
                                <!-- AddThis Button END -->

                                <?php echo $this->Html->link('<i class="fa fa-edit"></i> Edit', array('controller' => 'links', 'action' => 'edit', $stat['Link']['id']), array('escape' => false, 'class' => 'btn btn-primary btn-sm'));
                                ?>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        <?php endforeach; ?>
        <?php unset($stat); ?>

        <ul class="pagination">
            <!-- Shows the previous link -->
            <?php echo $this->Paginator->prev('«', array('tag' => 'li'), null, array('class' => 'disabled', 'tag' => 'li', 'disabledTag' => 'a')); ?>
            <!-- Shows the page numbers -->
            <?php //echo $this->Paginator->numbers();  ?>
            <?php
            echo $this->Paginator->numbers(array(
                'modulus' => 4,
                'separator' => '',
                'ellipsis' => '<li><a>...</a></li>',
                'tag' => 'li',
                'currentTag' => 'a',
                'first' => 2,
                'last' => 2
            ));
            ?>
            <!-- Shows the next link -->
            <?php echo $this->Paginator->next('»', array('tag' => 'li'), null, array('class' => 'disabled', 'tag' => 'li', 'disabledTag' => 'a')); ?>
        </ul>

        <br />
        <?php echo $this->Paginator->counter(); ?>




    </div>
</div>
<!-- END PAGE CONTENT-->



<script type="text/javascript">var addthis_config = {"ui_click": true};</script>
<script type="text/javascript" src="//s7.addthis.com/js/300/addthis_widget.js#pubid=ra-5335bfca1c256beb"></script>
